package com.example.login.Home

import android.support.v7.app.AppCompatActivity
import android.os.Bundle
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import android.widget.ImageView
import android.widget.TextView
import com.example.login.Adapter.AdapterMahasiswa
import com.example.login.Api.API
import com.example.login.Api.Common
import com.example.login.Model.Mahasiswa
import com.example.login.Model.MahasiswaModel

import com.example.login.R
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response


class MahasiswaActivity : AppCompatActivity() {

    lateinit var maha:RecyclerView

    lateinit var mService: API
    lateinit var layoutManager: LinearLayoutManager
    lateinit var adapterMahasiswa: AdapterMahasiswa


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_mahasiswa)
        maha = findViewById(R.id.maha)
        maha.setHasFixedSize(true)
        layoutManager = LinearLayoutManager(applicationContext)
        maha.layoutManager = layoutManager

        mService = Common.retrofitService

        getallmahasiswas()
    }

    private fun getallmahasiswas() {
        mService.getmahasiswas().enqueue(object : Callback<MutableList<MahasiswaModel>>{
            override fun onFailure(call: Call<MutableList<MahasiswaModel>>, t: Throwable) {
                print("Error : "+t.toString())
            }

            override fun onResponse(call: Call<MutableList<MahasiswaModel>>, response: Response<MutableList<MahasiswaModel>>) {
                try {
                    if (response!=null){
                        print( "Data : "+response.body())
                        adapterMahasiswa = AdapterMahasiswa(applicationContext, response.body() as MutableList<MahasiswaModel>)
                        adapterMahasiswa.notifyDataSetChanged()
                        maha.adapter = adapterMahasiswa
                    }
                }
                catch (t : ExceptionInInitializerError){
                    print( "Data : "+t.message)
                }
            }

        })
    }
}
