from django.shortcuts import render
from django.http import HttpResponse
from InvertedIndexSimulator.inverted import main
from xml.etree.ElementTree import ElementTree
from sklearn.feature_extraction.text import CountVectorizer
from itertools import count
import pandas as pd 
import xml.etree.ElementTree as et
import string
import re
import json
import xml.dom.minidom as minidom
import collections
try:
    from future_builtins import zip
except ImportError: # not 2.6+ or is 3.x
    try:
        from itertools import izip as zip # < 2.5 or 3.x
    except ImportError:
        pass

def home(request):
    return render(request, 'apps/home.html')

def dataframe(request):
    parse_data = et.parse("InvertedIndexSimulator/data/dataset_STBI.xml")
    res = main.show_dataframe(parse_data)
    
    context = {
        "res": res
    }
    
    return render(request, 'apps/dataframe.html', context)

def preprocessing(request):
    tree = ElementTree()
    all_doc_no, all_song, all_lyrics, N_DOC, all_sentence_doc = main.data_var(tree)
    
    tokens_doc = []
    for i in range(N_DOC):
        tokens_doc.append(main.remove_punc_tokenize(all_sentence_doc[i]))
    
    context = {
        "tokens_doc": tokens_doc
    }
    
    return render(request, 'apps/preprocessing.html', context)


def preprocessing2(request):
    
    tree = ElementTree()
    all_doc_no, all_song, all_lyrics, N_DOC, all_sentence_doc = main.data_var(tree)
    
    tokens_doc = []
    for i in range(N_DOC):
        tokens_doc.append(main.remove_punc_tokenize(all_sentence_doc[i]))
    
    for i in range(N_DOC):
        tokens_doc[i] = main.to_lower(tokens_doc[i])
    
    context = {
        "tokens_doc": tokens_doc
    }
    
    return render(request, 'apps/preprocessing2.html', context)
    

def preprocessing3(request):
    
    tree = ElementTree()
    all_doc_no, all_song, all_lyrics, N_DOC, all_sentence_doc = main.data_var(tree)
    
    tokens_doc = []
    for i in range(N_DOC):
        tokens_doc.append(main.remove_punc_tokenize(all_sentence_doc[i]))
    
    for i in range(N_DOC):
        tokens_doc[i] = main.to_lower(tokens_doc[i])
        
    for i in range(N_DOC):
        tokens_doc[i] = ([w for w in tokens_doc[i] if not any(j.isdigit() for j in w)])
    
    context = {
        "tokens_doc": tokens_doc
    }
    
    return render(request, 'apps/preprocessing3.html', context)

def preprocessing4(request):
    
    tree = ElementTree()
    all_doc_no, all_song, all_lyrics, N_DOC, all_sentence_doc = main.data_var(tree)
    
    tokens_doc = []
    for i in range(N_DOC):
        tokens_doc.append(main.remove_punc_tokenize(all_sentence_doc[i]))
    
    for i in range(N_DOC):
        tokens_doc[i] = main.to_lower(tokens_doc[i])
        
    for i in range(N_DOC):
        tokens_doc[i] = ([w for w in tokens_doc[i] if not any(j.isdigit() for j in w)])
    
    for i in range(N_DOC):
        tokens_doc[i] = main.stemming(tokens_doc[i])
    
    context = {
        "tokens_doc": tokens_doc
    }
    
    return render(request, 'apps/preprocessing4.html', context)


def indexing(request):
    
    dcmnt_xml = minidom.parse("InvertedIndexSimulator/data/dataset_STBI.xml")
    all_doc_no, N_DOC, all_sentence_doc_sample = main.load_data(dcmnt_xml)
    
    tokens_doc = []
    
    for i in range(N_DOC):
        tokens_doc.append(main.remove_punc_tokenize(all_sentence_doc_sample[i]))
    
    for i in range(N_DOC):
        tokens_doc[i] = main.to_lower(tokens_doc[i])
    
    for i in range(N_DOC):
        tokens_doc[i] = ([w for w in tokens_doc[i] if not any(j.isdigit() for j in w)])
        
    res = main.indexing(N_DOC, tokens_doc, all_doc_no)
    
    
    context = {
        "res": res,
    }
    
    return render(request, 'apps/indexing.html', context)
    
def index(request):
    return render(request, 'apps/index.html')

def phrases(request):
    return render(request, 'apps/phrases.html')
    
def search(request):
    return render(request, 'apps/search.html')

def result(request):
    dcmnt_xml = minidom.parse("InvertedIndexSimulator/data/dataset_STBI.xml")
    
    if request.method == 'POST':
        query = request.POST['querysearch']
        res = main.proximity(dcmnt_xml, query)

        content = {
            'res':res,
            'query':query
        }
        
    return render(request, 'apps/result.html', content)

def resultphrase(request):
    dcmnt_xml = minidom.parse("InvertedIndexSimulator/data/dataset_STBI.xml")
    
    if request.method == 'POST':
        query = request.POST['querysearch']
        res = main.phrase(dcmnt_xml, query)

        content = {
            'res':res,
            'query':query
        }
        
    return render(request, 'apps/resultphrase.html', content)

def lyric(request,id):

    lyrics, judul = main.detail(id)
    
    content = {
        'no': id,
        'judul':judul,
        'lyrics':lyrics,
    }
    
    return render(request, 'apps/lyric.html', content)